#include "DataRequest.h"

namespace DataTypes
{

DataRequest::DataRequest()
{
}

DataRequest::DataRequest(bool resp, list<DataParameter *> pars, string command)
{
	this->response = resp;
	this->parameters = pars;
	this->commandkey = command;
}

DataRequest::~DataRequest()
{
	std::list<DataParameter *>::iterator iter;
	iter = parameters.begin();
	while (iter!=parameters.end())
	{
		DataParameter *todestroy = (*iter);
		delete todestroy;
		iter++;
	}
}

bool DataRequest::GetResponse()
{
	return response;
}

list<DataParameter *> DataRequest::GetParameters()
{
	return parameters;
}

string DataRequest::GetCommandKey()
{
	return commandkey;
}


}
